#pragma once

#include "luascript.h"
#include "tools.h"
#include <string>
#include <map>
#include <vector>
#include <utility>
#include <unordered_map>

struct ItemAttributeInfo {
    ItemTooltipAttributes_t id;
    int32_t min;
    int32_t max;
    std::vector<int32_t> types;
};

struct SharedAttributeGroup {
    std::vector<int32_t> items;
    std::vector<ItemAttributeInfo> attributes;
};

typedef std::unordered_map<int32_t, std::vector<ItemAttributeInfo>> AllowedAttributesMap;
typedef std::unordered_map<ItemRarity_t, int32_t> ItemRarityModifiers;
typedef std::unordered_map<bool, std::unordered_map<ItemRarity_t, int32_t>> ItemRarityChances;
typedef std::unordered_map<int32_t, std::vector<int32_t>> RaritySkillItemsMap;
typedef std::vector<SharedAttributeGroup> SharedAttributesList;

class ItemRarityAttributes {
    public:
        static ItemRarityAttributes* getInstance() {
            static ItemRarityAttributes instance;
            return &instance;
        }

        bool load();
        ItemRarity_t getRandomRarityId(bool fromMonster) const;
        bool setRandomAttributes(ItemRarity_t rarityId, std::multimap<ItemTooltipAttributes_t, std::pair<int32_t, IntegerVector>>* attributes, int32_t itemId);
        double getRarityChance() const;

    private:
        bool loadChances(lua_State* L);
        bool loadModifiers(lua_State* L);
        bool loadAttributes(lua_State* L);

        ItemRarityModifiers m_modifiers;
        ItemRarityChances m_chances;
        RaritySkillItemsMap m_skillItems;
        AllowedAttributesMap m_allowedAttributes;
        SharedAttributesList m_sharedAttributes;
};
